<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Doctor extends Model 
{

    protected $table = 'doctors';
    public $timestamps = true;
    protected $fillable = array('name_ar', 'name_en', 'desc_ar', 'desc_en', 'speciality_id');

    public function clients()
    {
        return $this->hasMany('App\Models\Client');
    }

    public function photo()
    {
        return $this->morphOne('App\Models\Photo', 'photoable');
    }

    public function educations()
    {
        return $this->hasMany('App\Models\Education');
    }

    public function speciality()
    {
        return $this->belongsTo('App\Models\Speciality');
    }

}